<?php
/* --------------------------------------------------------------
   TrackingCodeService.php 2020-04-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode;

use Gambio\Admin\TrackingCode\Interfaces\TrackingCode;
use Gambio\Admin\TrackingCode\Interfaces\TrackingCodeId;
use Gambio\Admin\TrackingCode\Interfaces\TrackingCodeIds;
use Gambio\Admin\TrackingCode\Interfaces\TrackingCodes;
use Gambio\Admin\TrackingCode\Interfaces\TrackingCodeSqlCriteria;
use Gambio\Admin\TrackingCode\Interfaces\TrackingCodeSqlPagination;
use Gambio\Admin\TrackingCode\Repository\TrackingCodeRepository;

/**
 * Class TrackingCodeService
 *
 * @package Gambio\Admin\TrackingCode
 */
class TrackingCodeService implements Interfaces\TrackingCodeService
{
    /**
     * @var TrackingCodeRepository
     */
    private $repository;
    
    
    public function __construct(TrackingCodeRepository $repository)
    {
        $this->repository = $repository;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getAllTrackingCodes(
        TrackingCodeSqlCriteria $criteria,
        TrackingCodeSqlPagination $pagination
    ): TrackingCodes {
        return $this->repository->getAll($criteria, $pagination);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getTotalCountOfTrackingCodes(TrackingCodeSqlCriteria $criteria): int
    {
        return $this->repository->getTotalCount($criteria);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getTrackingCodeById(TrackingCodeId $id): TrackingCode
    {
        return $this->repository->getById($id);
    }
    
    
    /**
     * @inheritDoc
     */
    public function storeTrackingCode(TrackingCode $TrackingCode): TrackingCodeId
    {
        return $this->repository->store($TrackingCode);
    }
    
    
    /**
     * @inheritDoc
     */
    public function storeTrackingCodes(TrackingCodes $TrackingCodes): TrackingCodeIds
    {
        return $this->repository->storeMultiple($TrackingCodes);
    }
    
    
    /**
     * @inheritDoc
     */
    public function deleteTrackingCode(TrackingCodeId $id): void
    {
        $this->repository->delete($id);
    }
    
    
    /**
     * @inheritDoc
     */
    public function deleteTrackingCodes(TrackingCodeIds $ids): void
    {
        $this->repository->deleteMultiple($ids);
    }
}